<?php

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'enabled' => array(
        'title' => __('Enable/Disable', 'paygenius-hosted-payment-gateway'),
        'label' => __('Enable Paygenius', 'paygenius-hosted-payment-gateway'),
        'type' => 'checkbox',
        'description' => '',
        'default' => 'no'
    ),
    'title' => array(
        'title' => __('Title', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('This controls the title which the user sees during checkout.', 'paygenius-hosted-payment-gateway'),
        'default' => __('PayGenius Secure payment processing via Credit Card or EFT for South Africa', 'paygenius-hosted-payment-gateway'),
        'desc_tip' => true,
    ),
    'description' => array(
        'title' => __('Description', 'paygenius-hosted-payment-gateway'),
        'type' => 'textarea',
        'description' => __('This controls the description which the user sees during checkout.', 'paygenius-hosted-payment-gateway'),
        'default' => __('Pay by credit/cheque card or instant EFT. No need to register.', 'paygenius-hosted-payment-gateway'),
        'desc_tip' => true,
    ),
    'button-text' => array(
        'title' => __('Button Text', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('The text that will appear on the button clicking through to the PayGenus hosted payment pages', 'paygenius-hosted-payment-gateway'),
        'default' => __('Place Order', 'paygenius-hosted-payment-gateway'),
        'desc_tip' => true,
    ),
    'production-title' => array(
        'title' => __('Production Options', 'paygenius-hosted-payment-gateway'),
        'type' => 'title',
        'description' => empty($productionPages) ? 'Please enter valid API details and ensure you have available payment pages' : '',
    ),
    'paymentpage' => array(
        'title' => __('Payment Page', 'paygenius-hosted-payment-gateway'),
        'type' => 'select',
        'description' => __('The payment page to redirect the user to', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'options' => $productionPages,
        'desc_tip' => true,
    ),
    'endpoint' => array(
        'title' => __('Endpoint URL', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Production endpoint', 'paygenius-hosted-payment-gateway'),
        'default' => 'https://www.paygenius.co.za/pg/api/v2/',
        'desc_tip' => true,
    ),
    'token' => array(
        'title' => __('Token', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'desc_tip' => true,
    ),
    'secret' => array(
        'title' => __('Secret', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'desc_tip' => true,
    ),
    'testing-title' => array(
        'title' => __('Testing Options', 'paygenius-hosted-payment-gateway'),
        'type' => 'title',
        'description' => empty($testingPages) ? 'Please enter valid API details and ensure you have available payment pages' : '',
    ),
    'testmode' => array(
        'title' => __('Test mode', 'paygenius-hosted-payment-gateway'),
        'label' => __('Enable Test Mode', 'paygenius-hosted-payment-gateway'),
        'type' => 'checkbox',
        'description' => __('Place the payment gateway in test mode using test API keys.', 'paygenius-hosted-payment-gateway'),
        'default' => 'no',
        'desc_tip' => true,
    ),
    'testing-paymentpage' => array(
        'title' => __('Payment Page', 'paygenius-hosted-payment-gateway'),
        'type' => 'select',
        'description' => __('The payment page to redirect the user to', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'options' => $testingPages,
        'desc_tip' => true,
    ),
    'testing-endpoint' => array(
        'title' => __('Endpoint URL', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Testing endpoint', 'paygenius-hosted-payment-gateway'),
        'default' => 'https://developer.paygenius.co.za/pg/api/v2/',
        'desc_tip' => true,
    ),
    'testing-token' => array(
        'title' => __('Token', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'desc_tip' => true,
    ),
    'testing-secret' => array(
        'title' => __('Secret', 'paygenius-hosted-payment-gateway'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'paygenius-hosted-payment-gateway'),
        'default' => '',
        'desc_tip' => true,
    ),
    'use_sequence_number' => array(
        'title' => __('Sequential Order Numbers', 'paygenius-hosted-payment-gateway'),
        'label' => __('Enable Sequential Order Numbers', 'paygenius-hosted-payment-gateway'),
        'type' => 'checkbox',
        'description' => __('This allows the use of Woocommerce Sequential order numbers', 'paygenius-hosted-payment-gateway'),
        'default' => 'no',
        'desc_tip' => true,
    ),
);
